<?php
function get_options() {
	global $icdb, $options;
	$rows = $icdb->get_rows("SELECT * FROM ".$icdb->prefix."options");
	foreach ($rows as $row) {
		if (array_key_exists($row['options_key'], $options)) $options[$row['options_key']] = $row['options_value'];
	}
}

function update_options() {
	global $icdb, $options;
	foreach ($options as $key => $value) {
		$option = $icdb->get_row("SELECT * FROM ".$icdb->prefix."options WHERE options_key = '".mysql_real_escape_string($key)."'");
		if ($option) {
			$icdb->query("UPDATE ".$icdb->prefix."options SET options_value = '".mysql_real_escape_string($value)."' WHERE options_key = '".mysql_real_escape_string($key)."'");
		} else {
			$icdb->query("INSERT INTO ".$icdb->prefix."options (options_key, options_value) VALUES ('".mysql_real_escape_string($key)."', '".mysql_real_escape_string($value)."')");
		}
	}
}

function populate_options() {
	global $icdb, $options;
	foreach ($options as $key => $value) {
		if ($key != 'password') {
			if (isset($_POST[$key])) {
				if (get_magic_quotes_gpc()) {
					$options[$key] = stripslashes($_POST[$key]);
				}
				else $options[$key] = $_POST[$key];
			}
		}
	}
}

function check_options() {
	global $icdb, $options;
	$errors = array();
	if (!is_numeric($options['width']) || intval($options['width']) < 400) $errors[] = 'Width of popup box must be at least 400px';
	if (!is_numeric($options['height']) || intval($options['height']) < 100) $errors[] = 'Height of popup box must be at least 100px';
	if (get_rgb($options['popup_bg_color']) === false) $errors[] = 'Popup box color must be valid value';
	if (get_rgb($options['overlay_bg_color']) === false) $errors[] = 'Overlay color must be valid value';
	if (!is_numeric($options['overlay_opacity']) || floatval($options['overlay_opacity']) < 0 || floatval($options['overlay_opacity']) > 1) $errors[] = 'Overlay opacity must be between 0 and 1';
	if (!empty($options['popup_bg_url'])) {
		if (!preg_match('|^http(s)?://[a-z0-9-]+(.[a-z0-9-]+)*(:[0-9]+)?(/.*)?$|i', $options['popup_bg_url'])) $errors[] = 'Popup box background URL must be valid URL';
	}
	if (!empty($options['url'])) {
		if (!preg_match('|^http(s)?://[a-z0-9-]+(.[a-z0-9-]+)*(:[0-9]+)?(/.*)?$|i', $options['url'])) $errors[] = 'Website URL must be valid URL';
	}
	if ($options['load_enable'] == 'on') {
		if (!is_numeric($options['load_start_delay']) || intval($options['load_start_delay']) < 0) $errors[] = 'Start delay for open event must be valid value';
		if (!is_numeric($options['load_delay']) || intval($options['load_delay']) < 0) $errors[] = 'Autoclose delay for OnPageLoad event must be valid value';
	}
	if ($options['exit_enable'] == 'on') {
		if (!is_numeric($options['exit_delay']) || intval($options['exit_delay']) < 0) $errors[] = 'Autoclose delay for OnClickExternalLink event must be valid value';
	}
	if ($options['idle_enable'] == 'on') {
		if (!is_numeric($options['idle_delay']) || intval($options['idle_delay']) < 0) $errors[] = 'Idle delay for OnIdle event must be valid value';
	}
	if ($options['scroll_enable'] == 'on') {
		if (!is_numeric($options['scroll_offset']) || intval($options['scroll_offset']) < 200) $errors[] = 'Top offset for OnScrollDown event must be higher then 200px';
	}
	if ($options['mailchimp_enable'] == 'on') {
		if (empty($options['mailchimp_api_key']) || strpos($options['mailchimp_api_key'], '-') === false) $errors[] = 'Invalid MailChimp API Key';
		if (empty($options['mailchimp_list_id'])) $errors[] = 'Invalid MailChimp List ID';
	}
	if ($options['icontact_enable'] == 'on') {
		if (empty($options['icontact_appid'])) $errors[] = 'Invalid iContact AppID';
		if (empty($options['icontact_apiusername'])) $errors[] = 'Invalid iContact API Username';
		if (empty($options['icontact_apipassword'])) $errors[] = 'Invalid iContact API Password';
		if (empty($options['icontact_listid'])) $errors[] = 'Invalid iContact List ID';
	}
		if ($options['campaignmonitor_enable'] == 'on') {
			if (empty($options['campaignmonitor_api_key'])) $errors[] = 'Invalid Campaign Monitor API Key';
			if (empty($options['campaignmonitor_list_id'])) $errors[] = 'Invalid Campaign Monitor List ID';
		}
		if ($options['getresponse_enable'] == 'on') {
			if (empty($options['getresponse_api_key'])) $errors[] = 'Invalid GetResponse API Key';
			if (empty($options['getresponse_campaign_id'])) $errors[] = 'Invalid GetResponse Campaign ID';
		}
	if (empty($errors)) return true;
	return $errors;
}

function get_rgb($_color) {
	if (strlen($_color) != 7 && strlen($_color) != 4) return false;
	$color = preg_replace('/[^#a-fA-F0-9]/', '', $_color);
	if (strlen($color) != strlen($_color)) return false;
	if (strlen($color) == 7) list($r, $g, $b) = array($color[1].$color[2], $color[3].$color[4], $color[5].$color[6]);
	else list($r, $g, $b) = array($color[1].$color[1], $color[2].$color[2], $color[3].$color[3]);
	return array("r" => hexdec($r), "g" => hexdec($g), "b" => hexdec($b));
}

function page_switcher ($_urlbase, $_currentpage, $_totalpages) {
	$pageswitcher = "";
	if ($_totalpages > 1) {
		$pageswitcher = '<div class="tablenav bottom"><div class="tablenav-pages">Pages: <span class="pagiation-links">';
		if (strpos($_urlbase,"?") !== false) $_urlbase .= "&amp;";
		else $_urlbase .= "?";
		if ($_currentpage == 1) $pageswitcher .= "<strong>1</strong> ";
		else $pageswitcher .= " <a class='page' href='".$_urlbase."p=1'>1</a> ";

		$start = max($_currentpage-3, 2);
		$end = min(max($_currentpage+3,$start+6), $_totalpages-1);
		$start = max(min($start,$end-6), 2);
		if ($start > 2) $pageswitcher .= " <b>...</b> ";
		for ($i=$start; $i<=$end; $i++) {
			if ($_currentpage == $i) $pageswitcher .= " <strong>".$i."</strong> ";
			else $pageswitcher .= " <a class='page' href='".$_urlbase."p=".$i."'>".$i."</a> ";
		}
		if ($end < $_totalpages-1) $pageswitcher .= " <b>...</b> ";

		if ($_currentpage == $_totalpages) $pageswitcher .= " <strong>".$_totalpages."</strong> ";
		else $pageswitcher .= " <a class='page' href='".$_urlbase."p=".$_totalpages."'>".$_totalpages."</a> ";
		$pageswitcher .= "</span></div></div>";
	}
	return $pageswitcher;
}

function icontact_addcontact($name, $email) {
	global $options;
	$data = icontact_makecall($options['icontact_appid'], $options['icontact_apiusername'], $options['icontact_apipassword'], '/a/', null, 'accounts');
	if (!empty($data['errors'])) return;
	$account = $data['response'][0];
	if (empty($account) || intval($account->enabled != 1)) return;
	$data = icontact_makecall($options['icontact_appid'], $options['icontact_apiusername'], $options['icontact_apipassword'], '/a/'.$account->accountId.'/c/', null, 'clientfolders');
	if (!empty($data['errors'])) return;
	$client = $data['response'][0];
	if (empty($client)) return;
	$contact['email'] = $email;
	if ($options['disable_name'] != 'on') $contact['firstName'] = $name;
	$contact['status'] = 'normal';
	$data = icontact_makecall($options['icontact_appid'], $options['icontact_apiusername'], $options['icontact_apipassword'], '/a/'.$account->accountId.'/c/'.$client->clientFolderId.'/contacts', array($contact), 'contacts');
	if (!empty($data['errors'])) return;
	$contact = $data['response'][0];
	if (empty($contact)) return;
	$subscriber['contactId'] = $contact->contactId;
	$subscriber['listId'] = $options['icontact_listid'];
	$subscriber['status'] = 'normal';
	$data = icontact_makecall($options['icontact_appid'], $options['icontact_apiusername'], $options['icontact_apipassword'], '/a/'.$account->accountId.'/c/'.$client->clientFolderId.'/subscriptions', array($subscriber), 'subscriptions');
}

function icontact_getlists() {
	global $options;
	$data = icontact_makecall($options['icontact_appid'], $options['icontact_apiusername'], $options['icontact_apipassword'], '/a/', null, 'accounts');
	if (!empty($data['errors'])) return array();
	$account = $data['response'][0];
	if (empty($account) || intval($account->enabled != 1)) return;
	$data = icontact_makecall($options['icontact_appid'], $options['icontact_apiusername'], $options['icontact_apipassword'], '/a/'.$account->accountId.'/c/', null, 'clientfolders');
	if (!empty($data['errors'])) return array();
	$client = $data['response'][0];
	if (empty($client)) return array();
	$data = icontact_makecall($options['icontact_appid'], $options['icontact_apiusername'], $options['icontact_apipassword'], '/a/'.$account->accountId.'/c/'.$client->clientFolderId.'/lists', array(), 'lists');
	if (!empty($data['errors'])) return array();
	if (!is_array($data['response'])) return array();
	$lists = array();
	foreach ($data['response'] as $list) {
		$lists[$list->listId] = $list->name;
	}
	return $lists;
}

function icontact_makecall($appid, $apiusername, $apipassword, $resource, $postdata = null, $returnkey = null) {
	$return = array();
	$url = "https://app.icontact.com/icp".$resource;
	$headers = array(
		'Except:', 
		'Accept:  application/json', 
		'Content-type:  application/json', 
		'Api-Version:  2.2',
		'Api-AppId:  '.$appid, 
		'Api-Username:  '.$apiusername, 
		'Api-Password:  '.$apipassword
	);
	$handle = curl_init();
	curl_setopt($handle, CURLOPT_HTTPHEADER, $headers);
	curl_setopt($handle, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($handle, CURLOPT_SSL_VERIFYPEER, false);
	if (!empty($postdata)) {
		curl_setopt($handle, CURLOPT_POST, true);
		curl_setopt($handle, CURLOPT_POSTFIELDS, json_encode($postdata));
	}
	curl_setopt($handle, CURLOPT_URL, $url);
	if (!$response_json = curl_exec($handle)) {
		$return['errors'][] = 'Unable to execute the cURL handle.';
	}
	if (!$response = json_decode($response_json)) {
		$return['errors'][] = 'The iContact API did not return valid JSON.';
	}
	curl_close($handle);
	if (!empty($response->errors)) {
		foreach ($response->errors as $error) {
			$return['errors'][] = $error;
		}
	}
	if (!empty($return['errors'])) return $return;
	if (empty($returnkey)) {
		$return['response'] = $response;
	} else {
		$return['response'] = $response->$returnkey;
	}
	return $return;
}

function getresponse_getcampaigns() {
	global $options;
	$request = json_encode(
		array(
			'method' => 'get_campaigns',
			'params' => array(
				$options['getresponse_api_key']
			),
			'id' => ''
		)
	);

	$curl = curl_init('https://api2.getresponse.com/');
	curl_setopt($curl, CURLOPT_POST, 1);
	curl_setopt($curl, CURLOPT_POSTFIELDS, $request);
	$header = array(
		'Content-Type: application/json',
		'Content-Length: '.strlen($request)
	);
	curl_setopt($curl, CURLOPT_PORT, 443);
	curl_setopt($curl, CURLOPT_HTTPHEADER, $header);
	curl_setopt($curl, CURLOPT_TIMEOUT, 10);
	curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, 1); // verify certificate
	curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 2); // check existence of CN and verify that it matches hostname
	curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($curl, CURLOPT_FORBID_REUSE, 1);
	curl_setopt($curl, CURLOPT_FRESH_CONNECT, 1);
	curl_setopt($curl, CURLOPT_HEADER, 0);
									
	$response = curl_exec($curl);
						
	if (curl_error($curl)) return array();
	$httpCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
	if ($httpCode != '200') return array();
	curl_close($curl);
						
	$post = json_decode($response, true);
	if(!empty($post['error'])) return array();
	if (empty($post['result'])) return array();
	$campaigns = array();
	foreach ($post['result'] as $key => $value) {
		$campaigns[$key] = $value['name'];
	}
	return $campaigns;
}

function install() {
	global $icdb;
	$table_name = $icdb->prefix."users";
	if($icdb->get_var("SHOW TABLES LIKE '".$table_name."'") != $table_name) {
		$sql = "CREATE TABLE IF NOT EXISTS ".$table_name." (
			id int(11) NOT NULL AUTO_INCREMENT,
			name varchar(255) COLLATE utf8_unicode_ci NOT NULL,
			email varchar(255) COLLATE utf8_unicode_ci NOT NULL,
			registered int(11) NOT NULL,
			deleted int(11) NOT NULL DEFAULT '0',
			UNIQUE KEY id (id)
		) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;";
		$icdb->query($sql);
	}
	$table_name = $icdb->prefix."options";
	if($icdb->get_var("SHOW TABLES LIKE '".$table_name."'") != $table_name) {
		$sql = "CREATE TABLE IF NOT EXISTS ".$table_name." (
			id int(11) NOT NULL AUTO_INCREMENT,
			options_key varchar(255) COLLATE utf8_unicode_ci NOT NULL,
			options_value text COLLATE utf8_unicode_ci NOT NULL,
			UNIQUE KEY id (id)
		) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;";
		$icdb->query($sql);
	}
	$table_name = $icdb->prefix."sessions";
	if($icdb->get_var("SHOW TABLES LIKE '".$table_name."'") != $table_name) {
		$sql = "CREATE TABLE IF NOT EXISTS ".$table_name." (
			id int(11) NOT NULL AUTO_INCREMENT,
			session_id varchar(255) COLLATE utf8_unicode_ci NOT NULL,
			registered int(11) NOT NULL,
			valid_period int(11) NOT NULL,
			UNIQUE KEY id (id)
		) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;";
		$icdb->query($sql);
	}
}
?>